package aln.SpawnCommands;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.ClickEvent.Action;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.EventHandler;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.GameData;

@Mod(modid = ModInfo.ID,name=ModInfo.NAME,version=ModInfo.VERS,acceptableRemoteVersions="*") // mc1.7.2, 1.7.10, 1.8
//@Mod(modid=ModInfo.ID,name=ModInfo.NAME,version=ModInfo.VERS) // mc1.6.4
//@NetworkMod(clientSideRequired=false,serverSideRequired=true) // mc1.6.4

public class SpawnCommands {

  @Instance(ModInfo.ID) // are these 2 lines needed
  public static SpawnCommands instance;
  
  public static boolean isSingleplayer = true;
  public static boolean isMultiplayer = false; // values corrected dynamically in serverStart()
  //static IntegratedServer mcSingleplayerServer = null;
  //static MinecraftServer mcMultiplayerServer = null;
  
  public static String configBasePath = null; // this is corrected dynamically in serverStart()
  
  public static final String fileNameMiscConfig = "_miscellaneous.config";
  public static String[][] miscConfigArray = null;
  public static long miscConfigDateCode = 0; // compared to file modification date to see if reload is needed
  
  public static final String fileNameCommandPermissionsConfig = "_commandPermissions.config";
  public static String[][] commandPermissions = null;
  public static long commandPermissionsDateCode = 0; // compared to file modification date to see if reload is needed
  
  public static final String fileNameCommandNamesConfig = "_commandNames.config";
  public static String[][] commandNames = null;
  
  public static final String fileNameSpawnInBlocksConfig = "_canSpawnInsideBlockNameList.config";
  public static long spawnInBlocksDateCode = 0; // compared to file modification date to see if reload is needed
  public static String[]  spawnInBlocksID;
  public static Integer[] spawnInBlocksMeta;
  public static String    spawnInBlocksErrors;
  
  public static final String folderSharedNamedLocations = "_sharedNamedLocations";
  
  @SidedProxy(clientSide=ModInfo.CLIENTPROXY,serverSide=ModInfo.COMMONPROXY)
  public static CommonProxy proxy;
  
  @EventHandler
  public void preload(FMLPreInitializationEvent event) {
    //Do.Trace("FMLPreInit finished\n");
  }
  
  @EventHandler
  public void load(FMLInitializationEvent event) {
    //Do.Trace("FMLInit finished");
  }

  @EventHandler
  public void postload(FMLPostInitializationEvent event) {
    //Do.Trace("FMLPostInit finished");
  }
  
  @EventHandler
  public void serverStart(FMLServerStartingEvent event) {
    //System.out.println(ModInfo.NAME + " FMLServerStartingEvent started");
    
    // detect if singleplayer or multiplayer server.  there should be a better way to detect this.
    try { isSingleplayer = (Minecraft.getMinecraft() != null); } catch (NoClassDefFoundError e1) { isSingleplayer = false; }
    isMultiplayer = ! isSingleplayer;
    
    // bad code experiment:
    //if ( isSingleplayer ) { mcSingleplayerServer = Minecraft.getMinecraft().getIntegratedServer(); }
    //else { mcMultiplayerServer = event.getServer(); }
    
    // detect what folder to use for config files. This must be before configBasePath is used.
    if ( isMultiplayer ) 
      { configBasePath = event.getServer().getEntityWorld().getSaveHandler().getWorldDirectory().getPath() +"/"+ ModInfo.ID +"-config-folder/"; } 
    else 
      { configBasePath = "./saves/"+ Minecraft.getMinecraft().getIntegratedServer().getFolderName() +"/"+ ModInfo.ID +"-config-folder/"; }
    
    // initialize config files if needed
    Do.StringToFile("./config/"+ModInfo.ID+".config","The configuration files for this mod are inside the appropriate world or /saves folder.\nLook there for the "+ModInfo.ID+" configuration files."); 
    
    // CONVERT config files from version 1.4.1 and down, to 2.0.0
    if ( Do.folderExists("./config/"+ModInfo.ID) && (! Do.folderExists(configBasePath+".")) ) { // if old config folder does exist and new one doesnt exist
      Do.moveFolder("./config/"+ModInfo.ID,configBasePath+".");
      // search for and move and rename all /back saved locations from the main config folder to the player's folder.
      File fromPathFolder = new File(configBasePath);
      String[] fileNameList = fromPathFolder.list();
      for (int i=0; i < fileNameList.length; i++) {
        if ( Do.fileExists(configBasePath+fileNameList[i]) ) {
          Pattern pattern = Pattern.compile("^(.*)_GoBackLocation$");
          Matcher matcher = pattern.matcher(fileNameList[i]);
          if ( matcher.find() ) { 
            Do.StringToFile(configBasePath+matcher.group(1)+"/_"+matcher.group(1)+"_GoBackLocation", Do.FileToString(configBasePath+fileNameList[i]) );
            File f = new File(configBasePath+fileNameList[i]);
            f.delete();
          }
        }
      } // end for
    }
    if ( Do.fileExists(configBasePath + "canSpawnInsideBlockList") ) { // rename to new
      File fh1 = new File(configBasePath + "canSpawnInsideBlockList");
      File fh2 = new File(configBasePath + fileNameSpawnInBlocksConfig);
      fh1.renameTo(fh2);
    }
    
    // make the main config folders for this mod
    Do.folderMake(configBasePath + ".");
    Do.folderMake(configBasePath + folderSharedNamedLocations);
    
    if (! Do.fileExists(configBasePath + fileNameMiscConfig)) {
        Do.StringToFile(configBasePath + fileNameMiscConfig,
          "AdvancedCommandsEnabled=false\nallowWithCheatsDisabled=false\nHomeWithNamedLocations=false\nAllowToLeaveTheDragon=false\nLimitTheNumberOfNamedLocationsPerPlayer=false\nTheNamedLocationsLimitNumber=3\nteleportask responseTimeLimitSeconds=45\nteleportask requestJustCameInDelaySeconds=1.2\nteleportask lastPlayerAskedTimeoutHours=9\n"
        ); // defaults
    }
    loadMiscConfig();
    // CONVERT config files from version 1.4.1 and down, to 2.0.0
    if ( Do.fileExists(configBasePath + "NamesEnabled") ) {
      File fh = new File(configBasePath + "NamesEnabled");
      fh.delete();
      miscConfigArray = Do.setConfigArrayValue(SpawnCommands.miscConfigArray,"AdvancedCommandsEnabled","true");
      miscConfigArray = Do.setConfigArrayValue(SpawnCommands.miscConfigArray,"HomeWithNamedLocations","true");
      saveMiscConfig();
    }
    // CONVERT 2.0.0 to 2.1.0 (add AllowToLeaveTheDragon in The End, allows you to teleport out even if the dragon is still alive.)
    if ( Do.getConfigArrayValue(SpawnCommands.miscConfigArray, "AllowToLeaveTheDragon").equals("") ) {
      miscConfigArray = Do.setConfigArrayValue(miscConfigArray, "AllowToLeaveTheDragon", "false");
      miscConfigArray = Do.setConfigArrayValue(miscConfigArray, "LimitTheNumberOfNamedLocationsPerPlayer", "false");
      miscConfigArray = Do.setConfigArrayValue(miscConfigArray, "TheNamedLocationsLimitNumber", "3");
      miscConfigArray = Do.setConfigArrayValue(miscConfigArray, "teleportask responseTimeLimitSeconds", "45");
      miscConfigArray = Do.setConfigArrayValue(miscConfigArray, "teleportask requestJustCameInDelaySeconds", "1.2");
      miscConfigArray = Do.setConfigArrayValue(miscConfigArray, "teleportask lastPlayerAskedTimeoutHours", "9");
      saveMiscConfig();
    }
    
    if (! Do.fileExists(configBasePath + fileNameCommandPermissionsConfig)) {
        Do.StringToFile(configBasePath + fileNameCommandPermissionsConfig,
            "// This file is checked each time a command in this mod is used.\n// command=[all|enabled|op|no]\n// example: back=op\n\nspawn=all\nspawnName=enabled\nspawn.=all\nspawn!=all\nspawn?=all\nback=enabled\nspawn+=all\nspawn+enable=op\nspawn+@sharedlocation=op\nspawn+name=enabled\nspawn+nameWithCoordinates=enabled\nspawn-=all\nspawn-name=enabled\nspawn-@sharedlocation=op\nspawns=all\nhome=all\nsethome=all\nspawnhelp=all\nspawnblockdata=op\nta=enabled\n"
        ); // defaults
    }
    loadCommandPermissionsConfig();
    // CONVERT 2.0.0 to 2.1.0 (add new commands)
    if ( Do.getConfigArrayValue(commandPermissions, "spawnblockdata").equals("") ) {
      commandPermissions = Do.setConfigArrayValue(SpawnCommands.commandPermissions, "spawnblockdata", "op");
      commandPermissions = Do.setConfigArrayValue(SpawnCommands.commandPermissions, "ta", "enabled");
      saveCommandPermissionsConfig();
    }
    
    if (! Do.fileExists(configBasePath + fileNameCommandNamesConfig)) {
      Do.StringToFile(configBasePath + fileNameCommandNamesConfig,
        "// This file is loaded once on server startup\n// Deleting this file will reset it to defaults on game restart\n// originalCommand=newCommand\n// example: back=goback\n\nspawn=spawn\nspawn.=spawn.\nspawn!=spawn!\nspawn?=spawn?\nback=back\nspawn+=spawn+\nspawn-=spawn-\nspawns=spawns\nhome=home\nsethome=sethome\nspawnhelp=spawnhelp\nspawnblockdata=spawnblockdata\nta=ta"
      ); // defaults
    }
    loadCommandNamesConfig();
    // CONVERT 2.0.0 to 2.1.0 (add new commands)
    if ( Do.getConfigArrayValue(commandNames, "spawnblockdata").equals("") ) {
      commandNames = Do.setConfigArrayValue(SpawnCommands.commandNames, "spawnblockdata", "spawnblockdata");
      commandNames = Do.setConfigArrayValue(SpawnCommands.commandNames, "ta", "ta");
      saveCommandNamesConfig();
    }
    
    // initialize SpawnInBlocksConfig.  must be done postload or after to include the blocks from all mods.
    if ( ! Do.fileExists(configBasePath + fileNameSpawnInBlocksConfig)) { // for mc 1.7.2+ NameList
      // default with known problem blocks:
      String GeneratedNameList = "\nThaumcraft:blockAiry\nRailcraft:residual.heat\nRailcraft:tile.railcraft.residual.heat\nTConstruct:decoration.stonetorch\n";
      
      GeneratedNameList += "\n// Generated list of block names: (delete this file and restart the server to refresh this list) ";
      
      for ( Object i : GameData.getBlockRegistry().getKeys() ) { GeneratedNameList += "  " + i.toString(); }
      
      GeneratedNameList += "\n";
      Do.StringToFile(configBasePath + fileNameSpawnInBlocksConfig, 
      "// Block Names you add here allow the player to spawn into them. Some vanilla blocks are hard coded:\n" +
      "//      air, bed, tallgrass, red_flower, yellow_flower, deadbush, vine, snow_layer, and torch.\n" +
      "// Adding a 2nd number to an entry specifies the metadata/damage number to match.\n" + 
      "// If there is just a block name then meta data is ignored.\n"+ 
      "// You may use spaces or commas to separate the two parameters on the lines below.\n" +
      "// Example:  minecraft:sapling,2  would compare block 'sapling' to the block id in question and compre its meta data to 2.\n" +
      "//      This would allow you to spawn while standing inside a Birch tree sapling specifically.\n" +
      "// One entry per line and as many lines as you want.  Comments may be removed if you wish.\n" +
      "\n\n\n" + GeneratedNameList);
    }
    
    MinecraftForge.EVENT_BUS.register(new ForgeHooks()); // must be after the configBase has been defined.
    
    // register commands, if they are not disabled in the config
    ServerCommandManager manager = (ServerCommandManager) MinecraftServer.getServer().getCommandManager();
    
    if ( ! Do.getConfigArrayValue(commandPermissions,"spawn").equalsIgnoreCase("no") ) 
    { manager.registerCommand(new CommandSpawn()); }
    if ( ! Do.getConfigArrayValue(commandPermissions,"spawn.").equalsIgnoreCase("no") ) 
    { manager.registerCommand(new CommandSpawnPoint()); }
    if ( ! Do.getConfigArrayValue(commandPermissions,"spawn!").equalsIgnoreCase("no") ) 
    { manager.registerCommand(new CommandSpawnSet()); }
    if ( ! Do.getConfigArrayValue(commandPermissions,"spawn?").equalsIgnoreCase("no") ) 
    { manager.registerCommand(new CommandSpawnQuery()); }
    if ( ! Do.getConfigArrayValue(commandPermissions,"spawn+").equalsIgnoreCase("no") ) 
    { manager.registerCommand(new CommandSpawnPlus()); }
    if ( ! Do.getConfigArrayValue(commandPermissions,"spawn-").equalsIgnoreCase("no") ) 
    { manager.registerCommand(new CommandSpawnMinus()); }
    if ( ! Do.getConfigArrayValue(commandPermissions,"spawns").equalsIgnoreCase("no") ) 
    { manager.registerCommand(new CommandSpawns()); }
    if ( ! Do.getConfigArrayValue(commandPermissions,"home").equalsIgnoreCase("no") ) 
    { manager.registerCommand(new CommandHome()); }
    if ( ! Do.getConfigArrayValue(commandPermissions,"sethome").equalsIgnoreCase("no") ) 
    { manager.registerCommand(new CommandSetHome()); }
    if ( ! Do.getConfigArrayValue(commandPermissions,"spawnhelp").equalsIgnoreCase("no") ) 
    { manager.registerCommand(new CommandSpawnHelp()); }
    if ( ! Do.getConfigArrayValue(commandPermissions,"back").equalsIgnoreCase("no") ) 
    { manager.registerCommand(new CommandBack()); }
    if ( ! Do.getConfigArrayValue(commandPermissions,"spawnblockdata").equalsIgnoreCase("no") ) 
    { manager.registerCommand(new CommandSpawnBlockData()); }
    if ( ! Do.getConfigArrayValue(commandPermissions,"ta").equalsIgnoreCase("no") ) 
    { manager.registerCommand(new CommandTeleportAsk()); }
    
    //System.out.println(ModInfo.NAME + " FMLServerStartingEvent ended");
    System.out.println(ModInfo.NAME +" v"+ ModInfo.VERS +" ready");
  } // end serverLoad
  
  public static void showHelp(EntityPlayer player) {
    Do.Say(player," ");
    Do.Say(player,"§R"+ ModInfo.NAME +" v"+ ModInfo.VERS +" quick help:");
    Do.Say(player,"  /"+ Do.getConfigArrayValue(commandNames,"spawn")   +"    To the main world spawn point.");
    Do.Say(player,"  /"+ Do.getConfigArrayValue(commandNames,"spawn.")  +"    To your bed/home location if it is set.");
    Do.Say(player,"  /"+ Do.getConfigArrayValue(commandNames,"spawn!")  +"    Sets your bed/home location.");
    Do.Say(player,"  /"+ Do.getConfigArrayValue(commandNames,"spawn?")  +"    Displays coordinates.");
    Do.Say(player,"  §e/"+Do.getConfigArrayValue(commandNames,"spawn+") +" mylavabase§R  Creates your named spawn point.");
    Do.Say(player,"  §e/"+Do.getConfigArrayValue(commandNames,"spawn")  +" mylavabase§R     Teleports you there.");
    Do.Say(player,"  /"+ Do.getConfigArrayValue(commandNames,"spawn-")  +" mybasename     Removes a named location.");
    Do.Say(player,"  /"+ Do.getConfigArrayValue(commandNames,"spawn+")  
        +" enable  /"+ Do.getConfigArrayValue(commandNames,"spawn+") 
        +" disable  /"+ Do.getConfigArrayValue(commandNames,"spawns") 
        +"  /"+ Do.getConfigArrayValue(commandNames,"spawn") 
        +" help");
    Do.Say(player,"  /"+ Do.getConfigArrayValue(commandNames,"home")    
        +"  /"+ Do.getConfigArrayValue(commandNames,"sethome") 
        +"  /"+ Do.getConfigArrayValue(commandNames,"back") 
        +"  /"+ Do.getConfigArrayValue(commandNames,"spawn+") 
        +" myplace -123 65 42  §e/" + Do.getConfigArrayValue(commandNames,"ta")+"§r");
    if ( ( ! Do.getConfigArrayValue(commandPermissions,"spawnblockdata").equalsIgnoreCase("no") ) && ( Do.IsOp(player) ) ) 
    { Do.Say(player,"  /"+ Do.getConfigArrayValue(commandNames,"spawnblockdata")+"  Displays block data where standing."); }
    return;
  }
  
  public static void loadMiscConfig() {
    if ( miscConfigDateCode != Do.fileDateModified(configBasePath + fileNameMiscConfig) ) { // only load if changed.
     	 miscConfigDateCode    = Do.fileDateModified(configBasePath + fileNameMiscConfig); // new reference point for the date modified
     	 miscConfigArray     = Do.getConfigArrayFile(configBasePath + fileNameMiscConfig);
    }
  }
  public static boolean saveMiscConfig() {
    return Do.putConfigArrayFile(configBasePath + fileNameMiscConfig, miscConfigArray);
  }
	
  public static void loadCommandPermissionsConfig() {
    if ( commandPermissionsDateCode != Do.fileDateModified(configBasePath + fileNameCommandPermissionsConfig) ) { // only load if changed.
    	 commandPermissionsDateCode    = Do.fileDateModified(configBasePath + fileNameCommandPermissionsConfig); // new reference point for the date modified
    	 commandPermissions          = Do.getConfigArrayFile(configBasePath + fileNameCommandPermissionsConfig);
    }
  }
  public static boolean saveCommandPermissionsConfig() {
    return Do.putConfigArrayFile(configBasePath + fileNameCommandPermissionsConfig, commandPermissions);
  }
  
  public static void loadCommandNamesConfig() {
    commandNames = Do.getConfigArrayFile(configBasePath + fileNameCommandNamesConfig);
  }
  public static boolean saveCommandNamesConfig() {
    return Do.putConfigArrayFile(configBasePath + fileNameCommandNamesConfig, commandNames);
  }
  
  public static void listNamedLocations(EntityPlayer player) {
    // get, sort, and display the list of SHARED named locations
    File thefolder = new File(configBasePath+folderSharedNamedLocations );
    String[] filesInDir = thefolder.list();
    Arrays.sort(filesInDir);
    int locationCount = 0;
    
    SpawnCommands.loadCommandPermissionsConfig();
    
    IChatComponent comp = null;
    IChatComponent theListCC = new ChatComponentText("");
    
    player.addChatComponentMessage(new ChatComponentText(" "));
    
    // display before the list of locations.  Only display these commands if they are available to the player.
    comp = new ChatComponentText("clickable ");
    theListCC.appendSibling(comp);
    
    if (   (!( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawnhelp").equalsIgnoreCase("op") && (! Do.IsOp(player)) ))
        && (!( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawnhelp").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ))
        && (!( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawnhelp").equalsIgnoreCase("no") ))
       )
    {
      comp = new ChatComponentText("?");
      comp.setChatStyle(new ChatStyle().setChatClickEvent(new ClickEvent(Action.RUN_COMMAND, "/"+Do.getConfigArrayValue(commandNames,"spawnhelp") ) {}));
      theListCC.appendSibling(comp);
    }
    
    if (   (!( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn").equalsIgnoreCase("op") && (! Do.IsOp(player)) ))
        && (!( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ))
        && (!( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn").equalsIgnoreCase("no") ))
       )
    {
      comp = new ChatComponentText(" ");
      theListCC.appendSibling(comp);
      comp = new ChatComponentText("/"+Do.getConfigArrayValue(commandNames,"spawn"));
      comp.setChatStyle(new ChatStyle().setChatClickEvent(new ClickEvent(Action.RUN_COMMAND, "/"+Do.getConfigArrayValue(commandNames,"spawn") ) {}));
      theListCC.appendSibling(comp);
    }
    
    if (   (!( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn.").equalsIgnoreCase("op") && (! Do.IsOp(player)) ))
        && (!( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn.").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ))
        && (!( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn.").equalsIgnoreCase("no") ))
       )
    {
      comp = new ChatComponentText(" ");
      theListCC.appendSibling(comp);
      comp = new ChatComponentText("/"+Do.getConfigArrayValue(commandNames,"spawn."));
      comp.setChatStyle(new ChatStyle().setChatClickEvent(new ClickEvent(Action.RUN_COMMAND, "/"+Do.getConfigArrayValue(commandNames,"spawn.") ) {}));
      theListCC.appendSibling(comp);
    }
    
    if (   (!( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "back").equalsIgnoreCase("op") && (! Do.IsOp(player)) ))
        && (!( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "back").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ))
        && (!( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "back").equalsIgnoreCase("no") ))
       )
    {
      comp = new ChatComponentText(" ");
      theListCC.appendSibling(comp);
      comp = new ChatComponentText("/"+Do.getConfigArrayValue(commandNames,"back"));
      comp.setChatStyle(new ChatStyle().setChatClickEvent(new ClickEvent(Action.RUN_COMMAND, "/"+Do.getConfigArrayValue(commandNames,"back") ) {}));
      theListCC.appendSibling(comp);
    }
    
    player.addChatComponentMessage(theListCC);
    theListCC = new ChatComponentText("");
    
    comp = new ChatComponentText("  §e:");
    theListCC.appendSibling(comp);
    //String thelist = "§e:";
    
    for ( int i=0; i<filesInDir.length; i++ ) {
      // get named location data
      String fc = Do.FileToString(configBasePath+folderSharedNamedLocations+"/"+filesInDir[i]); // file content
      String[] fcValues = fc.split(","); // parsed
      if ( fcValues.length != 6 ) { Do.Err("Internal Error: expected 5 values: x y z yaw pitch then dimensionID. Location: "+filesInDir[i] +" in the shared locations folder."); }
      String theColor = "";
      //if ( Integer.parseInt(fcValues[5]) != player.worldObj.provider.getDimensionId() ) { theColor="§7"; } else { theColor="§e"; } // mc1.8
      if ( Integer.parseInt(fcValues[5]) != player.worldObj.provider.dimensionId ) { theColor="§7"; } else { theColor="§e"; } // mc1.7.10
      
      comp = new ChatComponentText("  ");
      theListCC.appendSibling(comp);
      comp = new ChatComponentText("§a@§r"+theColor+filesInDir[i]+"§r");
      comp.setChatStyle(new ChatStyle().setChatClickEvent(new ClickEvent(Action.RUN_COMMAND, "/"+Do.getConfigArrayValue(commandNames,"spawn")+" @"+filesInDir[i]) {}));
      theListCC.appendSibling(comp);
      //thelist += "  §a@§r" + theColor + filesInDir[i];
      
      locationCount++;
    }
    
    // get, sort, and display the list of named locations for this PLAYER
    Do.folderMake(configBasePath + player.getGameProfile().getName()); // mc1.7.10
    thefolder = new File(configBasePath + player.getGameProfile().getName()); // mc1.7.10
    filesInDir = thefolder.list();
    //if (( filesInDir.length == 0 ) && (locationCount == 0)) { Do.Say(player, "You have no named locations."); return; }
    if ( ((filesInDir == null) || ( filesInDir.length == 0 )) && (locationCount == 0)) { Do.Say(player, "You have no named locations."); return; }
    Arrays.sort(filesInDir);
    for ( int i=0; i<filesInDir.length; i++ ) {
      if ( ! filesInDir[i].substring(0,1).equals("_") ) { // if not the go back file or other system file 
        // get named location data
        String fc = Do.FileToString(configBasePath+player.getGameProfile().getName()+"/"+filesInDir[i]); // mc1.7.10 // file content
        String[] fcValues = fc.split(","); // parsed
        if ( fcValues.length != 6 ) { Do.Err("Internal Error: expected 5 values: x y z yaw pitch then dimensionID. Location: "+filesInDir[i] +" for player "+ player.getGameProfile().getName() ); } // mc1.7.10
        String theColor = "";
        //if ( Integer.parseInt(fcValues[5]) != player.worldObj.provider.getDimensionId() ) { theColor="§7"; } else { theColor="§e"; } // mc1.8 
        if ( Integer.parseInt(fcValues[5]) != player.worldObj.provider.dimensionId ) { theColor="§7"; } else { theColor="§e"; } // mc1.7.10 
        comp = new ChatComponentText("  ");
        theListCC.appendSibling(comp);
        comp = new ChatComponentText(theColor+filesInDir[i]+"§r");
        comp.setChatStyle(new ChatStyle().setChatClickEvent(new ClickEvent(Action.RUN_COMMAND, "/"+Do.getConfigArrayValue(commandNames,"spawn")+" "+filesInDir[i]) {}));
        theListCC.appendSibling(comp);
        //thelist += "  " + theColor + filesInDir[i];
        locationCount++;
      }
    }
    if ( locationCount == 0 ) { Do.Say(player, "You have no named locations."); return; }
    comp = new ChatComponentText("  §e.§r");
    theListCC.appendSibling(comp);
    //thelist += "  §e.§r";
    player.addChatComponentMessage(theListCC);
    
    //Do.Say(player, thelist); // is there a length limit to chat messages?
    return;
  }
  
  public static boolean advancedCommandsAreEnabled() { // a version with type double as opposed to int
    loadMiscConfig();
    return Do.getConfigArrayValueBoolean(miscConfigArray,"AdvancedCommandsEnabled");
  }
  
  public static boolean canSpawnInsideBlock(EntityPlayer player, double x, double y, double z) {
    return canSpawnInsideBlock(player,(int)x,(int)y,(int)z);
  }
  
  public static boolean canSpawnInsideBlock(EntityPlayer player, int x, int y, int z) {
    World world = player.worldObj;
    String[] spawnInBlocksLines = null;
    if ( y > world.getActualHeight() ) { return true; }
    if ( y < 1 ) { return false; }
    Block blockID = player.worldObj.getBlock(x, y, z);
    int blockMetaData = player.worldObj.getBlockMetadata(x,y,z);
    // if standard IDs then its ok
    if 
    (
      (blockID == Blocks.air) || // air 
      (blockID == Blocks.bed) || // yes it is ok to spawn inside a bed.
      (blockID == Blocks.tallgrass) || 
      (blockID == Blocks.red_flower) || 
      (blockID == Blocks.yellow_flower) ||
      (blockID == Blocks.deadbush) || 
      (blockID == Blocks.vine) ||
      (blockID == Blocks.snow_layer) ||
      (blockID == Blocks.torch) 
    )
    { return true; }
    // read config file for spawning inside blocks
    String fileName = configBasePath + fileNameSpawnInBlocksConfig;
    if ( spawnInBlocksDateCode != Do.fileDateModified(fileName) ) { // only load if changed.
         spawnInBlocksDateCode  = Do.fileDateModified(fileName); // new reference point for the date modified
      spawnInBlocksErrors = "";
      String fileContent = Do.FileToString(fileName); // file content 
      fileContent = fileContent.replaceAll("\r","\n"); // fix windows style text files
      spawnInBlocksLines = fileContent.split("\n"); // split from string to string[]
      spawnInBlocksID = new String[spawnInBlocksLines.length];
      spawnInBlocksMeta = new Integer[spawnInBlocksLines.length];
      for (int i = 0; i < spawnInBlocksLines.length; i++ ) {
      spawnInBlocksLines[i] = spawnInBlocksLines[i].replaceAll("^\\s+",""); // remove leading white space
        spawnInBlocksID[i] = "";
        spawnInBlocksMeta[i] = -1;
        if ( (spawnInBlocksLines[i] != null) && ( spawnInBlocksLines[i].length() != 0 ) && ( ! spawnInBlocksLines[i].startsWith("//")) ) {
          String line = spawnInBlocksLines[i].replaceAll("//.*$",""); // remove all comments
          line = line.replaceAll("^[\\s\\,:]+",""); // remove leading white space, commas, and colons
          line = line.replaceAll("[ \\,]+",","); // compatible with space or comma separators
          line = line.replaceAll("[\\s\\n\\r]$",""); // remove all trailing white space and newlines
          String[] lineContent = line.split(","); // line content
          // error check and assign into arrays
          if ( lineContent.length >= 1 ) { // at least 1 parameter blockID
            // example:   Railcraft:residual.heat
            spawnInBlocksID[i] = lineContent[0];
            // GameData.getBlockRegistry().getNameForObject(world.getBlock((int)px,(int)py,(int)pz)) // working?
            // if (             Block.getBlockFromName(lineContent[0]) == null ) {
            if ( GameData.getBlockRegistry().getObject(lineContent[0]) == null ) {
              spawnInBlocksErrors += "SpawnCommands Config: file "+fileNameSpawnInBlocksConfig+" line "+(i+1)+" §eblock name§R '"+lineContent[0]+"' does not exist.  "; 
              spawnInBlocksID[i] = ""; 
            }
            if ( lineContent.length >= 2 ) { // 2 parameters ID and meta data
              try { spawnInBlocksMeta[i] = Integer.parseInt(lineContent[1]); } catch (NumberFormatException e) { 
                spawnInBlocksErrors += "SpawnCommands Config: file "+fileNameSpawnInBlocksConfig+" line "+(i+1)+" §eMetadata§R '"+lineContent[1]+"' is not a number.  "; 
                spawnInBlocksMeta[i] = -1;
              }
            }
          } // end len >=1
        }
      } // end for i 
    } // end if modified then load data from file into spawnInBlocksID and spawnInBlocksMeta    
    // loop through and compare IDs and Metas
    if ( spawnInBlocksErrors != "") { Do.Err(spawnInBlocksErrors); }
    for (int i = 0; i < spawnInBlocksID.length; i++ ) {
      if (spawnInBlocksID[i].length() > 0) { // dont bother checking if the line is blank
        if ( spawnInBlocksMeta[i] == -1 ) {
          //if (                        Block.getBlockFromName(spawnInBlocksID[i]) == blockID ) { return true; }
          if (  ((Block)GameData.getBlockRegistry().getObject(spawnInBlocksID[i])) == blockID ) { return true; }
        } else {
          //if ((                       Block.getBlockFromName(spawnInBlocksID[i]) == blockID) && ( spawnInBlocksMeta[i] == blockMetaData )) { return true; }
          if (( ((Block)GameData.getBlockRegistry().getObject(spawnInBlocksID[i])) == blockID) && ( spawnInBlocksMeta[i] == blockMetaData )) { return true; }
        }
      }
    } // end for i 
    return false;
  }
  
  public static void SetBedSpawnPoint(EntityPlayer player) {
    //int playerDim = player.worldObj.provider.getDimensionId(); // mc1.8
    int playerDim = player.worldObj.provider.dimensionId; // mc1.7.10
    
    if ( !(player.worldObj.provider.isSurfaceWorld()) ) {  // rule from EntityPlayer.trySleep(BlockPos)
      Do.Say(player, "Cannot set the bed/home location in this dimension.");
      return;
    }
    
    // get bed current location
    ChunkCoordinates bedChunkCoordinates = player.getBedLocation(playerDim);
    if ( bedChunkCoordinates == null) { bedChunkCoordinates = new ChunkCoordinates(); }

    // get players current location
    double px = Math.round(player.posX - .5); // player's coordinates rounded down
    double py = Math.round(player.posY - .5);
    double pz = Math.round(player.posZ - .5); // bed location uses no yaw and pitch

    // Don't spawn inside blocks check
    while ( ( py < player.worldObj.getActualHeight() ) 
        &&  ( (!SpawnCommands.canSpawnInsideBlock(player, px, py, pz)) || (!SpawnCommands.canSpawnInsideBlock(player, px, py + 1, pz)) )
          ) 
    { py++; }
    
    // falling check
    while ( ( py > 1 ) 
        &&  ( (SpawnCommands.canSpawnInsideBlock(player, px, py - 1, pz)) && (SpawnCommands.canSpawnInsideBlock(player, px, py, pz)) )
          ) 
    { py--; }
    
    // set the spawn point for their bed/home
    //player.setSpawnChunk(new BlockPos(px,py,pz), true, playerDim); // mc1.8
    bedChunkCoordinates.set((int)px, (int)py, (int)pz);
    player.setSpawnChunk(bedChunkCoordinates, true, playerDim);

    // verify it worked in this dimension
    //BlockPos realBedPos = player.getBedLocation(playerDim); // mc1.8
    ChunkCoordinates realBedCC = player.getBedLocation(playerDim); // mc1.7.10
    //if ( ( realBedPos == null ) || (realBedPos.getX() != px) || (realBedPos.getY() != py) || (realBedPos.getZ() != pz) ) { // mc1.8
    if ( ( realBedCC == null ) || (realBedCC.posX != px) || (realBedCC.posY != py) || (realBedCC.posZ != pz) ) { // mc1.7.10
      Do.Say(player, "§4Failed§r to set bed/home location"+ (playerDim != 0 ? " in this dimension" : "") +"." );
      return;
    }
    
    // lava under feet check // mc1.8
    //BlockPos posBelowFeet = new BlockPos(px, (py-1), pz);
    //if ((py>1) && ( ( player.worldObj.getBlockState(posBelowFeet).getBlock() == Blocks.lava) || ( player.worldObj.getBlockState(posBelowFeet).getBlock() == Blocks.flowing_lava) )) {
    //  player.worldObj.setBlockState(posBelowFeet, Blocks.cobblestone.getDefaultState());
    //}
    
    // lava under feet check // mc1.7.10
    if ((py>1) && ( ( player.worldObj.getBlock((int)px, (int)(py-1), (int)pz) == Blocks.lava) || ( player.worldObj.getBlock((int)px, (int)(py-1), (int)pz) == Blocks.flowing_lava) )) {
      player.worldObj.setBlock((int)px, (int)(py-1), (int)pz, Blocks.cobblestone);
    }

    // actually go there
    player.setPositionAndUpdate(px + .5, py, pz + .5); // doesn't use yaw and pitch for bed
    Do.Say(player, "Your bed/home location is now set.");
    return;
  }
  
  public static void GoToBedSpawnPoint(EntityPlayer player) {
    World world = player.worldObj;
    // get player's location at start of this teleport request
    double  px = Math.round(player.posX - .5); // player's coordinates rounded down
    double  py = Math.round(player.posY - .5);
    double  pz = Math.round(player.posZ - .5);
    Float   pyaw = player.rotationYaw;
    Float   ppitch = player.rotationPitch;
    //int     originDim = world.provider.getDimensionId(); // mc1.8
    int     originDim = world.provider.dimensionId; // mc1.7.10
    String newGoBackLocation = px +","+ py +","+ pz +","+ pyaw +","+ ppitch +","+ originDim;
    
    // get bed location
    int bedDim;
    boolean bedIsInThisDim;
    
    /**
    // dumps list of all loaded mod IDs to server console. un-comment section to use.
    List<ModContainer> theMods = Loader.instance().getModList();
    System.out.println("MOD LIST DUMP start");
    System.out.print("\n\n");
    Iterator<ModContainer> it1 = theMods.iterator(); 
    while (it1.hasNext()) { System.out.print(it1.next().getModId()+" "); }
    System.out.print("\n\n\n");
    System.out.println("MOD LIST DUMP stop");
    /**/

    // mc1.8
    //BlockPos bedPos = player.getBedLocation(originDim);
    //if ( bedPos == null ) { bedIsInThisDim = false; } else { bedIsInThisDim = true; } 
    //if ( bedIsInThisDim ) { bedDim = originDim; } else { bedDim = 0; }
    //bedPos = player.getBedLocation(bedDim);
    //if ( bedPos == null) { Do.Say(player, "Bed spawn point is not set."); return; }
    // remember to add exception for TwilightForest
    
    // mc1.7.10
    ChunkCoordinates bedCC = player.getBedLocation(originDim);
    if ( bedCC == null ) { bedIsInThisDim = false; } else { bedIsInThisDim = true; }
    if ( bedIsInThisDim ) { bedDim = originDim; } else { bedDim = 0; }
    if (  Do.isModIDLoaded("TwilightForest") 
       && (world.provider.getDimensionName().equals("Twilight Forest")) 
       && bedIsInThisDim 
       ) 
    { bedDim = 0; bedIsInThisDim = false; } // exception for TwilightForest mod
    
    bedCC = player.getBedLocation(bedDim);
    if ( bedCC == null) { Do.Say(player, "Bed spawn point is not set."); return; }
    
    // if changing dimensions
    if (! bedIsInThisDim ) { 
      // check if in The End dimension and if the dragon is alive
      boolean dragonIsAlive = false;
      if ( originDim == 1 ) { // if in The End ...
        for ( int k = 0; k < world.loadedEntityList.size(); k++ ) {
          Entity it = (Entity) world.loadedEntityList.get(k);
          if ( it instanceof EntityDragon ) { 
            dragonIsAlive = true;
            k = world.loadedEntityList.size();
          }
        }
      } // end dragon check
      // if trying to go out of The End
      SpawnCommands.loadMiscConfig();
      if (( originDim == 1 ) && ( bedDim != 1 ) && ( dragonIsAlive ) && (! Do.getConfigArrayValueBoolean(SpawnCommands.miscConfigArray, "AllowToLeaveTheDragon")) ) 
      { Do.Say(player,"The mighty dragon is in control of this world. You must defeat the dragon or death is your only escape!"); return; }
      // The following is a hack fix that overcomes a problem when directly leaving the end to any other dimension.
      // The problem: when you leave the end to another dimension the world will NOT load.
      // The solution: when you go to another dimension then go to a third one it WILL load, so we go to another one on the way.
      if ( ( originDim == 1 ) && ( bedDim != 1 ) ) {
        if ( bedDim == 0 ) { player.travelToDimension(-1); } else { player.travelToDimension(0); } 
      }
      player.travelToDimension(bedDim); // officially change dimension now
    } // end if changing dimensions
    
    // mc1.8
    //px = bedPos.getX();
    //py = bedPos.getY();
    //pz = bedPos.getZ(); // bed locations don't need yaw, or pitch
    
    // mc1.7.10
    px = bedCC.posX;
    py = bedCC.posY;
    pz = bedCC.posZ; // bed locations don't need yaw, or pitch
    
    // write the location of the next go back command
    if (! Do.StringToFile(configBasePath+player.getGameProfile().getName()+"/_"+player.getGameProfile().getName()+"_GoBackLocation", newGoBackLocation ) ) // mc1.7.10 
    { Do.Err(player,"SpawnCommands: GoToBedSpawnPoint: Could not create the file that stores the location to go back to."); return; }
    
    boolean spawnWasBlocked = false;
    
    // check if destination is an actual bed block, if so then try to move the bed location to beside it or last resort just above it.
    // this is to possibly help the problem of spawning inside the stone below the bed on slow load times.
    Block blockID = player.worldObj.getBlock((int)px, (int)py, (int)pz);
    if ( blockID == Blocks.bed ) { 
      // check around the bed in different directions
      Integer[][] searchGrid = 
      { 
        {-1, 0,0},{1, 0,0},{0, 0,-1},{0, 0,1},{-1, 0,-1},{1, 0,-1},{-1, 0,1},{1, 0,1},   
        {-1, 1,0},{1, 1,0},{0, 1,-1},{0, 1,1},{-1, 1,-1},{1, 1,-1},{-1, 1,1},{1, 1,1},   
        {-1,-1,0},{1,-1,0},{0,-1,-1},{0,-1,1},{-1,-1,-1},{1,-1,-1},{-1,-1,1},{1,-1,1},   
        {0,1,0} 
      }; // x y z offsets
      for (int i = 0;i<searchGrid.length;i++) {
        blockID =player.worldObj.getBlock((int) px+searchGrid[i][0],(int) py+searchGrid[i][1]  ,(int) pz+searchGrid[i][2]);
        if ( (blockID != Blocks.bed ) 
            &&      canSpawnInsideBlock(player, px+searchGrid[i][0],      py+searchGrid[i][1]  ,      pz+searchGrid[i][2])  // at feet
            &&      canSpawnInsideBlock(player, px+searchGrid[i][0],      py+searchGrid[i][1]+1,      pz+searchGrid[i][2])  // at head
            &&    (!canSpawnInsideBlock(player, px+searchGrid[i][0],      py+searchGrid[i][1]-1,      pz+searchGrid[i][2])) // under feet
           ) 
        { // then its a good location to change the bed location to
          px=px+searchGrid[i][0];
          py=py+searchGrid[i][1];
          pz=pz+searchGrid[i][2];
          spawnWasBlocked = true;
          break;
        }
      }
    }
    
    // Don't spawn inside blocks check 
    while ( ( py < player.worldObj.getActualHeight() ) 
        &&  ( (!SpawnCommands.canSpawnInsideBlock(player, px, py, pz)) || (!SpawnCommands.canSpawnInsideBlock(player, px, py + 1, pz)) )
          ) 
    { py++;
      spawnWasBlocked = true;
    }
    
    // falling check
    while ( ( py > 1 ) 
        &&  ( (SpawnCommands.canSpawnInsideBlock(player, px, py - 1, pz)) && (SpawnCommands.canSpawnInsideBlock(player, px, py, pz)) )
          ) 
    { py--;
      spawnWasBlocked = true;
    }
    
    // fix bed location
    //if (spawnWasBlocked) { player.setSpawnChunk(new BlockPos(px,py,pz), true, bedDim); } // mc1.8
    if (spawnWasBlocked) { player.setSpawnChunk(new ChunkCoordinates((int)px, (int)py, (int)pz), true, bedDim); } // mc1.7.10
    
    // lava under feet check
    // mc1.8
    //BlockPos posBelowFeet = new BlockPos(px, (py-1), pz);
    //if ((py>1) && ( ( player.worldObj.getBlockState(posBelowFeet).getBlock() == Blocks.lava) || ( player.worldObj.getBlockState(posBelowFeet).getBlock() == Blocks.flowing_lava) )) {
    //  player.worldObj.setBlockState(posBelowFeet, Blocks.cobblestone.getDefaultState());
    //}
    // mc1.7.10
    if ((py>1) && ( ( player.worldObj.getBlock((int)px, (int)(py-1), (int)pz) == Blocks.lava) || ( player.worldObj.getBlock((int)px, (int)(py-1), (int)pz) == Blocks.flowing_lava) )) {
      player.worldObj.setBlock((int)px, (int)(py-1), (int)pz, Blocks.cobblestone);
    }
    
    // actually go there now
    player.setPositionAndUpdate(px + .5, py, pz + .5); // beds don't use yaw and pitch
    return;
  }
  
  public static void commandSpawn(EntityPlayer player, String[] params) {
    World world = player.worldObj; 
    if ( world.isRemote ) { return; }
    loadCommandPermissionsConfig();
    loadMiscConfig();
    
    if (params.length > 1) { showHelp(player); return; }
    
    // get player's location at start of this teleport request
    double  px = Math.round(player.posX - .5); // player's coordinates rounded down
    double  py = Math.round(player.posY - .5);
    double  pz = Math.round(player.posZ - .5);
    Float   pyaw = player.rotationYaw;
    Float   ppitch = player.rotationPitch;
    //Integer pdim = world.provider.getDimensionId(); // mc1.8
    Integer pdim = world.provider.dimensionId; // mc1.7.10
    Integer originDim = pdim;
    String newGoBackLocation = px +","+ py +","+ pz +","+ pyaw +","+ ppitch +","+ pdim;
    
    boolean toMainSpawn = false;
    boolean isSharedName = false;
    String theName = "";
    
    if (params.length == 1) {
      if (params[0].equalsIgnoreCase("help")) { SpawnCommands.showHelp(player); return; }
      
      // validate named location name format. all letters and numbers and minus
      if ( params[0].substring(0,1).equals("@") ) { // if it starts with "@"
        isSharedName = true;
        params[0] = params[0].substring(1); // remove the "@"
        if ( params[0].length() == 0 ) { return; }
      }
      theName = params[0];
      theName = theName.replaceAll("[^a-zA-Z0-9\\-]","");
      if ( ! theName.contentEquals(params[0]) ) { Do.Say(player,"Named locations must use only numbers, letters, and '-'"); return; }
      theName = theName.toLowerCase();
      
      if ( ! isSharedName ) { // if we have a name and its not a shared name then permissions for spawnName
        // "no" and "op" and "enable" are handled here. "all" is the default.
        if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawnName").equalsIgnoreCase("no") ) 
        { Do.Say(player,"Spawning to a named location is not permitted. See config files."); return; }
        if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawnName").equalsIgnoreCase("op") && (! Do.IsOp(player)) ) 
        { Do.Say(player,"Spawning to a named location is an op only command.  You are not an op."); return; }
        if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawnName").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ) 
        { Do.Say(player,"Spawning to a named location is an advanced command and is not enabled for SpawnCommands."); return; }
      }
      
      // get current destination 
      String filePathAndName;
      if ( isSharedName ) 
      { filePathAndName = SpawnCommands.configBasePath+SpawnCommands.folderSharedNamedLocations+"/"+theName; }
      else
      { filePathAndName = SpawnCommands.configBasePath+player.getGameProfile().getName()+"/"+theName; } // mc1.7.10
      if (! Do.fileExists(filePathAndName)) {
        Do.Say(player, "Named location '"+ (isSharedName ? "@" : "") + theName +"' does not exist."); return;
      }
      String fileContent = Do.FileToString(filePathAndName);
      String[] fcValues = fileContent.split(","); // parse
      if ( fcValues.length != 6 ) { Do.Err(player, "Internal Error: expected 6 values: x y z yaw pitch then dimensionID. Teleport failed."); return; }
      px =   Double.parseDouble(fcValues[0]);
      py =   Double.parseDouble(fcValues[1]);
      pz =   Double.parseDouble(fcValues[2]);
      pyaw =   Float.parseFloat(fcValues[3]);
      ppitch = Float.parseFloat(fcValues[4]);
      pdim =   Integer.parseInt(fcValues[5]);
    } else { // params.length == 0 destination is main spawn
      toMainSpawn = true;
      // x y z defined at time of dimensional change below
      // pitch and yaw are still defined from the player's position above
      pdim = 0;        
    } // end if length == 1 or 0
    
    if ( originDim != pdim ) { // if changing dimensions
      // if in The End and the dragon is alive...
      boolean dragonIsAlive = false;
      if ( originDim == 1 ) { // if in The End ...
        for ( int k = 0; k < world.loadedEntityList.size(); k++ ) {
          Entity it = (Entity) world.loadedEntityList.get(k);
          if ( it instanceof EntityDragon ) { 
            dragonIsAlive = true;
            k = world.loadedEntityList.size();
          }
        }
      } // end dragon check          
      // if trying to go out of The End
      SpawnCommands.loadMiscConfig();
      if (( originDim == 1 ) && ( pdim != 1 ) && ( dragonIsAlive ) && (! Do.getConfigArrayValueBoolean(SpawnCommands.miscConfigArray, "AllowToLeaveTheDragon")) ) 
      { Do.Say(player,"The mighty dragon is in control of this world. You must defeat the dragon or death is your only escape!"); return; }
      // The following is a hack fix that overcomes a problem when directly leaving the end to any other dimension.
      // The problem: when you leave the end to another dimension the world will NOT load.
      // The solution: when you go to another dimension then go to a third one it WILL load, so we go to another one on the way.
      if ( ( originDim == 1 ) && ( pdim != 1 ) ) {
        if ( pdim == 0 ) { player.travelToDimension(-1); } else { player.travelToDimension(0); } 
      }
      player.travelToDimension(pdim); // officially change dimension now
    } // end if changing dimensions
    
    // write the location of the next go back command
    if (! Do.StringToFile( SpawnCommands.configBasePath + player.getGameProfile().getName() + "/_" + player.getGameProfile().getName() +"_GoBackLocation", newGoBackLocation ) ) // mc1.7.10
    { Do.Err(player,"CommandSpawn: Could not create the file that stores the location to go back to."); return; }

    if ( toMainSpawn ) { // this is here because we have to already be in the main dimension to get the main spawn coordinates
      // mc1.8
      //BlockPos pxyz = world.getSpawnPoint();
      //px = pxyz.getX();
      //py = pxyz.getY();
      //pz = pxyz.getZ();
      // mc1.7.10
      ChunkCoordinates pxyz = world.getSpawnPoint();
      px = pxyz.posX;
      py = pxyz.posY;
      pz = pxyz.posZ;
    }
    
    // Don't spawn inside blocks check
    while ( ( py < player.worldObj.getActualHeight() ) 
        &&  ( (!SpawnCommands.canSpawnInsideBlock(player, px, py, pz)) || (!SpawnCommands.canSpawnInsideBlock(player, px, py + 1, pz)) )
          ) 
    { py++; }
    // falling check
    while ( ( py > 1 ) 
        &&  ( (SpawnCommands.canSpawnInsideBlock(player, px, py - 1, pz)) && (SpawnCommands.canSpawnInsideBlock(player, px, py, pz)) )
          ) 
    { py--; }
    
    // lava under feet check
    // mc1.8
    //BlockPos posBelowFeet = new BlockPos(px, (py-1), pz);
    //if ((py>1) && ( ( player.worldObj.getBlockState(posBelowFeet).getBlock() == Blocks.lava) || ( player.worldObj.getBlockState(posBelowFeet).getBlock() == Blocks.flowing_lava) )) {
    //  player.worldObj.setBlockState(posBelowFeet, Blocks.cobblestone.getDefaultState());
    //}
    // mc1.7.10
    if ((py>1) && ( ( player.worldObj.getBlock((int)px, (int)(py-1), (int)pz) == Blocks.lava) || ( player.worldObj.getBlock((int)px, (int)(py-1), (int)pz) == Blocks.flowing_lava) )) {
      player.worldObj.setBlock((int)px, (int)(py-1), (int)pz, Blocks.cobblestone);
    }
    
    // actually go there now
    ((EntityPlayerMP) player).playerNetServerHandler.setPlayerLocation(px + .5d, py, pz + .5d, pyaw, ppitch);
    return;
    
  } // end commandSpawn
  
  public static void commandSpawnPlus(EntityPlayer player,String[] params) {
    World world = player.worldObj;
    if ( world.isRemote ) { return; }

    loadCommandPermissionsConfig();
    loadMiscConfig();
    
    if ( ( params.length == 0 ) || ( params.length == 2 ) || ( params.length == 3 ) || ( params.length > 4 ) || (params[0].equalsIgnoreCase("help")) ) 
    { SpawnCommands.showHelp(player); return; }
    
    // get player's location at start of this teleport request
    double  px = Math.round(player.posX - .5); // player's coordinates rounded down
    double  py = Math.round(player.posY - .5);
    double  pz = Math.round(player.posZ - .5);
    Float   pyaw = player.rotationYaw;
    Float   ppitch = player.rotationPitch;
    Integer pdim = world.provider.dimensionId;
    Integer originDim = pdim;
    String newGoBackLocation = px +","+ py +","+ pz +","+ pyaw +","+ ppitch +","+ pdim;
    
    // validate named location name format. all letters and numbers
    boolean isSharedName = false;
    if ( params[0].substring(0,1).equals("@") ) { // if it starts with "@"
      isSharedName = true;
      params[0] = params[0].substring(1); // remove the "@"
      if ( params[0].length() == 0 ) { return; }
    }
    String theName = params[0];
    theName = theName.replaceAll("[^a-zA-Z0-9\\-]","");
    if ( ! theName.contentEquals(params[0]) ) { Do.Say(player, "Named locations must use only numbers, letters, and '-'"); return; }
    theName = theName.toLowerCase();
    
    if ( isSharedName ) { 
      // "no" and "op" and "enable" are handled here. "all" is the default.
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn+@sharedlocation").equalsIgnoreCase("no") ) 
      { Do.Say(player,"Adding a shared §e@§Rname is not permitted. See config files."); return; }
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn+@sharedlocation").equalsIgnoreCase("op") && (! Do.IsOp(player)) ) 
      { Do.Say(player,"Adding a shared §e@§Rname is an op only command.  You are not an op."); return; }
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn+@sharedlocation").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ) 
      { Do.Say(player,"Adding a shared §e@§Rname is an advanced command and is not enabled for SpawnCommands."); return; }
    }

    if ( (theName.equalsIgnoreCase("enable") || theName.equalsIgnoreCase("disable") || theName.equalsIgnoreCase("enabled") || theName.equalsIgnoreCase("disabled")) ) { 
      // "no" and "op" and "enable" are handled here. "all" is the default.
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn+enable").equalsIgnoreCase("no") ) 
      { Do.Say(player,"The sub-command \"/"+Do.getConfigArrayValue(SpawnCommands.commandNames ,"spawn+")+" §eenable§R|§edisable§R\" is not permitted. See config files."); return; }
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn+enable").equalsIgnoreCase("op") && (! Do.IsOp(player)) ) 
      { Do.Say(player,"The sub-command \"/"+Do.getConfigArrayValue(SpawnCommands.commandNames ,"spawn+")+" §eenable§R|§edisable§R\" is an op only command.  You are not an op."); return; }
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn+enable").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ) 
      { Do.Say(player,"The sub-command \"/"+Do.getConfigArrayValue(SpawnCommands.commandNames ,"spawn+")+" §eenable§R|§edisable§R\" is an advanced command and is not enabled for SpawnCommands."); return; }
    }
    
    // /spawn+ enable
    if ( (theName.equalsIgnoreCase("enable") || theName.equalsIgnoreCase("enabled")) ) {
      if ( SpawnCommands.advancedCommandsAreEnabled() ) { Do.Say(player, "Advanced spawn commands are already enabled"); return; }
      SpawnCommands.miscConfigArray = Do.setConfigArrayValue(SpawnCommands.miscConfigArray,"AdvancedCommandsEnabled","true");
      if (! SpawnCommands.saveMiscConfig() ) { Do.Err(player,"Could not save changes to misc config file."); return; }
      Do.Say(player, "Advanced commands are now §eEnabled§r for SpawnCommands.");
      return; 
    }
    
    // /spawn+ disable 
    if ( (theName.equalsIgnoreCase("disable") || theName.equalsIgnoreCase("disabled")) ) {
      if ( ! SpawnCommands.advancedCommandsAreEnabled() ) { Do.Say(player, "Advanced spawn commands are already disabled"); return; }
      SpawnCommands.miscConfigArray = Do.setConfigArrayValue(SpawnCommands.miscConfigArray,"AdvancedCommandsEnabled","false");
      if (! SpawnCommands.saveMiscConfig() ) { Do.Err(player,"Could not save changes to misc config file."); return; }
      Do.Say(player, "Advanced commands are now §eDisabled§r for SpawnCommands.");
      return; 
    }
    
    // manually specified coordinates
    double parX = 0;
    double parY = 0;
    double parZ = 0;
    if ( params.length == 4 ) {
      
      // command permissions. "no" and "op" and "enable" are handled here. "all" is the default.
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn+NameWithCoordinates").equalsIgnoreCase("no") ) 
      { Do.Say(player,"Creating a named location with coordinates is disabled."); return; }
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn+NameWithCoordinates").equalsIgnoreCase("op") && (! Do.IsOp(player)) ) 
      { Do.Say(player,"Creating a named location with coordinates is an op only command.  You are not an op."); return; }
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn+NameWithCoordinates").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ) 
      { Do.Say(player,"Creating a named location with coordinates is an advanced spawn command and is not enabled."); return; }
      
      boolean parXYZerror = false;
      try { parX = Double.parseDouble(params[1]); } catch  (NumberFormatException e) { Do.Say(player, "X '"+params[1]+"' is not a number."); parXYZerror = true; }
      try { parY = Double.parseDouble(params[2]); } catch  (NumberFormatException e) { Do.Say(player, "Y '"+params[2]+"' is not a number."); parXYZerror = true; }
      try { parZ = Double.parseDouble(params[3]); } catch  (NumberFormatException e) { Do.Say(player, "Z '"+params[3]+"' is not a number."); parXYZerror = true; }
      if ( parXYZerror ) { return; }
    }
    
    if (( ! isSharedName ) && ( params.length == 1)) { // /spawn+ name 
      // "no" and "op" and "enable" are handled here. "all" is the default.
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn+name").equalsIgnoreCase("no") ) 
      { Do.Say(player,"Adding a named location is not permitted. See config files."); return; }
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn+name").equalsIgnoreCase("op") && (! Do.IsOp(player)) ) 
      { Do.Say(player,"Adding a named location is an op only command.  You are not an op."); return; }
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn+name").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ) 
      { Do.Say(player,"Adding a named location is an advanced command and is not enabled for SpawnCommands."); return; }
    }
    
    // set the location
    String coordinateSource = "";
    if ( params.length == 4 ) { // they specified coordinates
      px = Math.round(parX - .5);
      py = Math.round(parY - .5);
      pz = Math.round(parZ - .5);
      coordinateSource = "Using ( x"+(int)px+", y"+(int)py+", z"+(int)pz+" ) in this dimension.";
    } else { // they only specified a name
      px = Math.round(player.posX - .5); // player's coordinates rounded down
      py = Math.round(player.posY - .5);
      pz = Math.round(player.posZ - .5);
      coordinateSource = "Using your current coordinates.";
    }
    pyaw = player.rotationYaw;
    ppitch = player.rotationPitch;
    //pdim = player.worldObj.provider.getDimensionId(); // mc1.8 // player's current dimension
    pdim = player.worldObj.provider.dimensionId; // mc1.7.10 // player's current dimension
    
    // Don't spawn inside blocks check   
    while ( ( py < player.worldObj.getActualHeight() ) 
        &&  ( (!SpawnCommands.canSpawnInsideBlock(player, px, py, pz)) || (!SpawnCommands.canSpawnInsideBlock(player, px, py + 1, pz)) )
          ) 
    { py++; }
    // falling check
    while ( ( py > 1 ) 
        &&  ( (SpawnCommands.canSpawnInsideBlock(player, px, py - 1, pz)) && (SpawnCommands.canSpawnInsideBlock(player, px, py, pz)) )
          ) 
    { py--; }
    // lava under feet check
    // mc1.8
    //BlockPos posBelowFeet = new BlockPos(px, (py-1), pz);
    //if ((py>1) && ( ( player.worldObj.getBlockState(posBelowFeet).getBlock() == Blocks.lava) || ( player.worldObj.getBlockState(posBelowFeet).getBlock() == Blocks.flowing_lava) )) {
    //  player.worldObj.setBlockState(posBelowFeet, Blocks.cobblestone.getDefaultState());
    //}
    // mc1.7.10
    if ((py>1) && ( ( player.worldObj.getBlock((int)px, (int)(py-1), (int)pz) == Blocks.lava) || ( player.worldObj.getBlock((int)px, (int)(py-1), (int)pz) == Blocks.flowing_lava) )) {
      player.worldObj.setBlock((int)px, (int)(py-1), (int)pz, Blocks.cobblestone);
    }
    
    // identify the named locations folder and file
    String filePath;
    if ( isSharedName ) 
    { filePath = SpawnCommands.configBasePath+SpawnCommands.folderSharedNamedLocations+"/"; }
    else
    { filePath = SpawnCommands.configBasePath+player.getGameProfile().getName()+"/"; } // mc1.7.10
    String filePathAndName = filePath+theName;
    Do.folderMake(filePath+".");
    
    // Limit The Number Of Named Locations Per Player
    if ( Do.getConfigArrayValueBoolean(SpawnCommands.miscConfigArray,"LimitTheNumberOfNamedLocationsPerPlayer") && (! isSharedName)) {
      int theLimit = Do.getConfigArrayValueInteger(SpawnCommands.miscConfigArray,"TheNamedLocationsLimitNumber");
      // count their named locations and detect if replacing one of them.
      int isReplacementName = 0;
      File thefolder = new File(filePath+".");
      String[] filesInDir = thefolder.list();
      int numberOfNamedLocations = 0;
      if (filesInDir != null) {
        for ( int i=0; i<filesInDir.length; i++ ) {
          if ( filesInDir[i].equalsIgnoreCase(theName) ) { isReplacementName = 1; }
          if ( ! filesInDir[i].startsWith("_",0) ) { numberOfNamedLocations++; }
        }
      }
      if ( (numberOfNamedLocations - isReplacementName ) >= theLimit ) 
      { Do.Say(player,"Sorry, that would create more than the "+theLimit+" allowed named locations per player. Try removing one first?"); return; }
    }
    
    // write the named location file
    if (! Do.StringToFile(filePathAndName, px +","+ py +","+ pz +","+ pyaw +","+ ppitch +","+ pdim) ) 
    { Do.Err(player,"Named location NOT set. Check folder "+SpawnCommands.folderSharedNamedLocations); return; }
    
    Do.Say(player,coordinateSource); // from specified coords or from where player is
    
    // actually go there
    ((EntityPlayerMP) player).playerNetServerHandler.setPlayerLocation(px + .5d, py, pz + .5d, pyaw, ppitch);
    Do.Say(player, (isSharedName ? "@" : "") + theName + " location is now set.");
    
    // write the location of the next go back command
    if (! Do.StringToFile( SpawnCommands.configBasePath + player.getGameProfile().getName() + "/_" + player.getGameProfile().getName() +"_GoBackLocation", newGoBackLocation ) ) 
    { Do.Err(player,"CommandSpawn: Could not create the file that stores the location to go back to."); return; }
    
    return;
    
  } // end commandSpawnPlus
  
}
